﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Towary" %>
<%@ import Namespace="Soneta.Magazyny" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Zamówione towary</title>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<script runat="server"> 

        public class ParametryContext : ContextBase {
            public ParametryContext(Context cx)
                : base(cx) {
            }

            [Caption("Magazyn stanu towaru")]
            public Magazyn Magazyn {
                get { return (Magazyn)Context[typeof(Magazyn), false]; }
                set { Context[typeof(Magazyn)] = value; }
            }
        }

        ParametryContext parametry;

        [Context]
        public ParametryContext Parametry {
            get { return parametry; }
            set { parametry = value; }
        }



        public class Total : IComparable {
            readonly Towar towar;
            int liczba;
            bool różneWaluty;
            Currency wartość;
            decimal wartośćPLN;
            Quantity ilośćZamówień = Quantity.Empty;
            Quantity ilośćRezerwacji = Quantity.Empty;
            Quantity ilośćZasobówMinus = Quantity.Empty;
            Quantity stan = Quantity.Zero;

            public Total(Towar towar, StanMagazynuWorker smw) {
                this.towar = towar;
                smw.Towar = towar;
                this.stan = smw.StanMagazynu;
            }

            public void Add(PozycjaDokHandlowego poz) {
                if (poz.IlośćZasobu.IsZero) return;

                ++liczba;

                //
                // Ilość
                //
                ilośćZamówień += poz.IlośćZasobu;
                if (!(poz.Dokument.TypPartii == TypPartii.ZamówionyZasób || poz.Dokument.TypPartii == TypPartii.Brak))
                    ilośćRezerwacji += poz.IlośćZasobu;

                foreach (Zasob zasób in poz.Zasoby)
                    if (zasób.Partia.Typ==TypPartii.Zamówiony && zasób.Kierunek==KierunekPartii.Rozchód)
                        ilośćZasobówMinus += zasób.Ilosc;

                //
                // Wartość
                //
                decimal mnożnik = (decimal)(poz.IlośćZasobu.Value / poz.IloscMagazynu.Value);
                decimal vPLN = poz.Suma.Netto * mnożnik;
                Currency v = new Currency(poz.WartoscCy.Value * mnożnik, poz.WartoscCy.Symbol);

                if (wartośćPLN == 0) {
                    wartość = v;
                    wartośćPLN = vPLN;
                }
                else {
                    if (!Currency.EqualSymbols(poz.WartoscCy, wartość))
                        różneWaluty = true;
                    wartośćPLN += vPLN;
                    if (!różneWaluty)
                        wartość += v;
                }
            }

            public Towar Towar {
                get { return towar; }
            }

            public int Liczba {
                get { return liczba; }
            }

            public Quantity IlośćZamówień {
                get { return ilośćZamówień; }
            }

            public Quantity IlośćRezerwacji {
                get { return ilośćRezerwacji - ilośćZasobówMinus; }
            }

            public Quantity Stan {
                get { return stan; }
            }

            public Quantity Braki {
                get {
                    Quantity il = ilośćZamówień - ilośćRezerwacji;
                    if (il.IsZero) return ilośćZasobówMinus;
                    if (Stan >= il) return ilośćZasobówMinus;
                    return il - Stan + ilośćZasobówMinus;
                }
            }

            public Currency Wartość {
                get {
                    if (różneWaluty)
                        return wartośćPLN;
                    return wartość;
                }
            }

            public int CompareTo(object obj) {
                Total t = (Total)obj;
                return towar.Kod.CompareTo(t.Towar.Kod);
            }
        }

        public Quantity PozostałaIlość(PozycjaDokHandlowego pozycja) {
            Quantity iloscRoz = Quantity.Empty;
            ArrayList nazwy = new ArrayList();
            foreach (PozycjaRelacjiHandlowej prelacji in pozycja.PodrzędneRelacje) {
                if (prelacji.Podrzedna.Dokument.KierunekMagazynu == KierunekPartii.Rozchód) {
                    string nazwaRelacji = prelacji.Relacja.Definicja.ZNadrzednego.Nazwa;
                    if (!nazwy.Contains(nazwaRelacji))
                        nazwy.Add(nazwaRelacji);
                }
            }
            foreach (string nazwaRelacji in nazwy)
            {
                PozycjeWRelacji pwr = pozycja.Podrzędne[nazwaRelacji];
                iloscRoz += pozycja.Ilosc - pwr.PozostałoIlość;
            }
            return pozycja.Ilosc - iloscRoz;
        }
        /*
           public Quantity PozostałaIlość(PozycjaDokHandlowego pozycja) {
               Quantity iloscRoz = Quantity.Empty;
               foreach (PozycjaRelacjiHandlowej prelacji in pozycja.PodrzędneRelacje) {
                   if (prelacji.Podrzedna.Dokument.KierunekMagazynu == KierunekPartii.Rozchód) {
                       string nazwaRelacji = prelacji.Relacja.Definicja.ZNadrzednego.Nazwa;
                       PozycjeWRelacji pwr = pozycja.Podrzędne[nazwaRelacji];
                       iloscRoz += pozycja.Ilosc - pwr.PozostałoIlość;
                   }
               }
               return pozycja.Ilosc - iloscRoz;
           }       
         */
        
        void OnContextLoad(Object sender, EventArgs args) {

            Row[] rows = (Row[])dc[typeof(Row[])];
            Hashtable result = new Hashtable();
            int licznik = 0;

            StanMagazynuWorker smw = new StanMagazynuWorker();
            smw.Magazyn = Parametry.Magazyn;
            string x = "";
            foreach (DokumentHandlowy dokument in rows) {
                if (++licznik % 30 == 0)
                    System.Diagnostics.Trace.Write(licznik * 100 / rows.Length, "Progress");
                if (dokument.Zatwierdzony) {
                    foreach (PozycjaDokHandlowego pozycja in dokument.Pozycje) {
                        if (pozycja.Towar.Kod == "02725")
                        {
                            x += pozycja.Dokument.Numer.Pelny + ":" + PozostałaIlość(pozycja).ToString() + "; ";
                        }
                        if (PozostałaIlość(pozycja) <= Quantity.Zero) continue;
                        
                        Total t = (Total)result[pozycja.Towar];
                        if (t == null) {
                            t = new Total(pozycja.Towar, smw);
                            result.Add(pozycja.Towar, t);
                        }
                        t.Add(pozycja);
                    }
                }
            }

            ArrayList lista = new ArrayList(result.Values);
            lista.Sort();
            Grid.DataSource = lista;

        }

	</script>
	<body>
		<form id="Form1" method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="OnContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" title="Zamówione towary|</STRONG>Okres:<STRONG> {2}|</STRONG>Magazyn:<STRONG> {3}</STRONG>"
				runat="server" DataMember3="Magazyn" DataMember2="FromTo"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel">
				<COLUMNS>
					<ea:GridColumn ID="GridColumn1" Caption="LP." DataMember="#" Align="Right" Width="4" runat="server"></ea:GridColumn>
					<ea:GridColumn ID="GridColumn2" DataMember="Towar.Kod" Width="17" Caption="Towar~Kod" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn ID="GridColumn3" DataMember="Towar.Nazwa" Caption="Towar~Nazwa" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn ID="GridColumn4" DataMember="IlośćZam&#243;wień" Align="Right" Width="11" Caption="Ilość~zam&#243;wiona" runat="server"></ea:GridColumn>
                    <ea:GridColumn ID="GridColumn5" runat="server" Align="Right" Caption="Ilość~rezerwacji" DataMember="IlośćRezerwacji"
                        Width="11">
                    </ea:GridColumn>
					<ea:GridColumn ID="GridColumn6" DataMember="Stan" Align="Right" Width="11" Caption="Stan|magaz. po rezerw." runat="server"></ea:GridColumn>
					<ea:GridColumn ID="GridColumn7" DataMember="Braki" Align="Right" Width="11" runat="server"></ea:GridColumn>
					<ea:GridColumn ID="GridColumn8" DataMember="Wartość" Align="Right" Width="13" Total="Sum" runat="server" Caption="Wartość zam&#243;wień"></ea:GridColumn>
					<ea:GridColumn ID="GridColumn9" DataMember="Liczba" Align="Right" Width="8" runat="server" Caption="Liczba pozycji"></ea:GridColumn>
				</COLUMNS>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter>
		</form>
	</body>
</HTML>

